/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.DesertRhinoEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class DesertRhinoModel<T extends DesertRhinoEntity>
extends ListModel<T> {
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart right_front_leg;
    private final ModelPart right_back_leg;
    private final ModelPart left_back_leg;
    private final ModelPart left_front_leg;

    public DesertRhinoModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.left_front_leg = this.main.m_171324_("left_front_leg");
        this.left_back_leg = this.main.m_171324_("left_back_leg");
        this.right_back_leg = this.main.m_171324_("right_back_leg");
        this.right_front_leg = this.main.m_171324_("right_front_leg");
        this.body = this.main.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition modelPartData2 = modelPartData1.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -23.0f, -36.0f, 24.0f, 23.0f, 27.0f).m_171514_(23, 82).m_171481_(-8.0f, -28.0f, -32.0f, 4.0f, 5.0f, 4.0f).m_171514_(54, 50).m_171481_(5.0f, -29.0f, -25.0f, 4.0f, 6.0f, 4.0f).m_171514_(86, 73).m_171481_(-6.0f, -27.0f, -22.0f, 4.0f, 4.0f, 4.0f).m_171514_(39, 82).m_171481_(0.0f, -26.0f, -16.0f, 4.0f, 3.0f, 4.0f).m_171514_(0, 50).m_171481_(-10.0f, -18.0f, -9.0f, 20.0f, 18.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)13.0f));
        modelPartData2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(85, 85).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 13.0f).m_171514_(0, 0).m_171481_(-3.0f, -2.0f, 13.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)5.0f));
        modelPartData2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(68, 50).m_171481_(-5.0f, -5.0f, -13.0f, 10.0f, 10.0f, 13.0f).m_171514_(16, 12).m_171481_(-1.0f, -10.0f, -6.0f, 2.0f, 5.0f, 2.0f).m_171514_(0, 12).m_171481_(-2.0f, -14.0f, -12.0f, 4.0f, 9.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-36.0f));
        modelPartData1.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(75, 0).m_171481_(-4.0f, 0.0f, -6.0f, 9.0f, 13.0f, 12.0f), PartPose.m_171419_((float)6.0f, (float)-13.0f, (float)-14.0f));
        modelPartData1.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(32, 89).m_171481_(-4.0f, 0.0f, -4.0f, 7.0f, 13.0f, 9.0f), PartPose.m_171419_((float)6.0f, (float)-13.0f, (float)12.0f));
        modelPartData1.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171481_(-3.0f, 0.0f, -4.0f, 7.0f, 13.0f, 9.0f), PartPose.m_171419_((float)-6.0f, (float)-13.0f, (float)12.0f));
        modelPartData1.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(56, 73).m_171481_(-5.0f, 0.0f, -6.0f, 9.0f, 13.0f, 12.0f), PartPose.m_171419_((float)-6.0f, (float)-13.0f, (float)-14.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.main);
    }

    public void setAngles(T fungus, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.tail.f_104203_ = -1.0f;
        this.head.f_104203_ = headPitch * 0.010453292f;
        this.head.f_104204_ = headYaw * 0.010453292f;
        this.right_back_leg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.left_back_leg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.right_front_leg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.left_front_leg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance * 0.3f;
        float k = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
        if (k > 0.0f) {
            this.head.f_104203_ = -k * 0.8f;
        }
    }
}

